;**********************************************************
;*                                                        *
;* Projekt: Kabeltester fr MSwitch                       *
;* Version: 0.1                                           *
;* Datum:   26.02.2004                                    *
;* Autor:   Robert Hoffmann                               *
;*                                                        *
;* (C) 2002, RHS Friedberg/Wulfertshausen                 *
;*                                                        *
;* Dieses Rahmenprogramm wurde erstellt von:R.Hoffmann    *
;**********************************************************
;* Fr ICD-Debugging mssen folgende Resourcen fr den    *
;* ICD verfgbar sein:                                    *
;* >  File Register:$70,$BB-$BF,                          *
;* >  Program Memory: $6E0-7FF                            *
;**********************************************************

;********************************************************************************
;*										*
;*			H I S T O R Y - Programmnderungen			*
;*										*
;********************************************************************************
;*										*
;********************************************************************************

;********************************************
;* Einstellungen fr Listfile und Assembler *
;********************************************
	list	P=PIC16F872, C=132, N=0, T=ON
	expand
	errorlevel	-302

;**********************************************
;* Includefile fr diesen Prozessor einbinden *
;**********************************************
	include	P16F872.INC

;****************************
;*  CONFIG-Wort definieren  *
;****************************
; Das Wort CONFIG enthlt folgende Einstellungen:
;_CP_ALL		Code protection all ($0000 bis $7FFF)
;_CP_HALF		Code protection ($0000 bis $03FFF)
;_CP_UPPER_256		Code protection ($0000 bis $6FFF)
;_CP_OFF		Code protection off
;_DEBUG_ON		In-Circuit-Debugger enabled
;_DEBUG_OFF		In-Circuit-Debugger disabled
;_WRT_ENABLE_ON		Flash Program Memory write enabled
;_WRT_ENABLE_OFF	Flash Program Memory write disabled
;_CPD_ON		EE-Memory Code Protection on
;_CPD_OFF		EE-Memory Code Protection off
;_LVP_ON		Low Voltage In-Circuit-Programming enabled
;_LVP_OFF		Low Voltage In-Circuit-Programming disabled
;_BODEN_ON		Brown-Out-Reset enabled
;_BODEN_OFF		Brown-Out-Reset diasabled
;_PWRTE_OFF		Power-Up-Timer-disabled
;_PWRTE_ON		Power-Up-Timer enabled
;_WDT_ON		Watchdog-Timer enabled
;_WDT_OFF		Watchdog-Timer disabeld
;_LP_OSC		LP-Oszillator
;_XT_OSC		XT-Oszillator
;_HS_OSC		HS-Oszillator
;_RC_OSC		RC-Oszillator

	__config	_CP_ALL & _DEBUG_ON & _WRT_ENABLE_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _PWRTE_ON & _WDT_ON & _XT_OSC
	__idlocs	H'0B00'

;****************************
;*                          *
;*   Hardwaredefinitionen   *
;*    fr diesen PIC        *
;*                          *
;****************************


#define RA0	PORTA,0		; Port A Bitdefintionen - RA0/AN0
#define RA1	PORTA,1		; RA1/AN1
#define RA2	PORTA,2		; RA1/AN2/VREF-
#define RA3	PORTA,3		; RA3/AN3/VREF+
#define RA4	PORTA,4		; RA4/T0CKI
#define RA5	PORTA,5		; RA5/AN4/-SS

#define RB0	PORTB,0		; Port B Bitdefinitionen - RB0/INT
#define RB1	PORTB,1		; RB1
#define RB2	PORTB,1		; RB2
#define RB3	PORTB,1		; RB3/PGM
#define RB4	PORTB,1		; RB4
#define RB5	PORTB,1		; RB5
#define RB6	PORTB,1		; RB6/PGC
#define RB7	PORTB,1		; RB7/PGD

#define	RC0	PORTC,0		; Port C Bitdefinitionen - RC0/T1OSO/T1CKI
#define	RC1	PORTC,1		; RC1/T1OSI
#define	RC2	PORTC,2		; RC2/CCP1
#define	RC3	PORTC,3		; RC3/SCK/SCL
#define	RC4	PORTC,4		; RC4/SDI/SDA
#define RC5	PORTC,5		; RC5/SDO
#define RC6	PORTC,6		; RC6
#define RC7	PORTC,7		; RC7

;****************************
;*                          *
;*   Hardwaredefinitionen   *
;*    fr diese Hardware    *
;*                          *
;****************************

;****************************
;*                          *
;*     Programmkonstante    *
;*      fr diesen PIC      *
;*                          *
;****************************
RAM1_START	equ	H'20'
RAM1_END	equ	H'7F'
RAM2_START	equ	H'A0'
RAM2_END	equ	H'BF'

;****************************
;*                          *
;*     Programmkonstante    *
;*     fr dieses Projekt   *
;*                          *
;****************************
Timer0Val	equ	H'B3'	; Wert fr Timer0 => $FF-(10msec/1usec/128{Prescaler}-2)
Timer1Hi	equ	H'00'	; Hi-Wert fr Timer1
Timer1Lo	equ	H'00'	; Lo-Wert fr Timer1
Timer2Per	equ	H'00'	; Wert fr Timer2-Perioden Register
Timer2Reg	equ	H'00'	; Wert fr Timer2-Perioden Register
CCRegHi		equ	H'00'	; Hi-Wert fr Compare-Capture-Register
CCRegLo		equ	H'00'	; Lo-Wert fr Compare-Capture-Register
SSPAdr		equ	H'00'	; Werte fr Zugriff auf SSP
SSPBuf		equ	H'00'	; Werte fr Zugriff auf SSP

ScaleFaktor2	equ	D'10'	; Vorteiler fr Softwaretimer2 (Basiszeit 10msec / 10 = 100msec)
ScaleFaktor3	equ	D'100'	; Vorteiler fr Softwaretimer3 (Basiszeit 10msec / 100 = 1sek)

k100msec	equ	D'10'	; Konstante fr Softtimer Wartezeit 100 msec
k250msec	equ	D'25'	; Konstante fr Softtimer Wartezeit 250 msec
k500msec	equ	D'50'	; Konstante fr Softtimer Wartezeit 100 msec
k1sec		equ	D'100'	; Konstante fr Softtimer Wartezeit 1 sek
k2sec		equ	D'200'	; Konstante fr Softtimer Wartezeit 2 sek
k2k5sec		equ	D'250'	; Konstante fr Softtimer Wartezeit 2.5 sek

kPS100msec	equ	D'1'	; Konstante fr Softtimer Wartezeit 100 msec
kPS200msec	equ	D'2'	; Konstante fr Softtimer Wartezeit ca. 200 msec
kPS500msec	equ	D'5'	; Konstante fr Softtimer Wartezeit 500 msec
kPS1sec		equ	D'10'	; Konstante fr Softtimer Wartezeit 1 sek
kPS2sec		equ	D'20'	; Konstante fr Softtimer Wartezeit 2 sek
kPS2k5sec	equ	D'25'	; Konstante fr Softtimer Wartezeit 2.5 sek
kPS3sec		equ	D'30'	; Konstante fr Softtimer Wartezeit 3 sek
kPS4sec		equ	D'40'	; Konstante fr Softtimer Wartezeit 4 sek
kPS5sec		equ	D'50'	; Konstante fr Softtimer Wartezeit 5 sek

kBlkFast	equ	D'15'	; Konstante fr 3.3Hz: 3.3Hz =  300msec = 150msec Periode / 10msec
kBlkSlow	equ	D'70'	; Konstante fr 0.7Hz: 0.7Hz = 1400msec = 700msec Periode / 10msec

;****************************
;*   Variablen in Bank 0    *
;* General Purpose Register *
;*       von $20 bis $6F    *
;*       von $71 bis $7F    *
;* $70 ICD-Reserviert 	    *
;****************************
FlagBits	equ	H'20'	; Flags fr Ablauf und Zustnde
InBitsB		equ	H'21'	; gelesener Wert von Port B
InBitsA		equ	H'22'	; gelesener Wert von Port A

; Varibelen des Rahenprogramms
LEDFlags	equ	H'60'	; Zustand der Status-LED
TimerFlags	equ	H'61'	; Flags fr meine Timer
PreScaler2	equ	H'62'	; Vorteilerzhler fr (Software)-Timer2 
PreScaler3	equ	H'63'	; Vorteilerzhler fr (Software)-Timer3
Timer1Val	equ	H'64'	; Wartezeit fr Softwaretimer
Timer2Val	equ	H'65'	; Wartezeit fr Softwaretimer
Timer3Val	equ	H'66'	; Wartezeit fr Softwaretimer

FastCounter	equ	H'67'	; Zhler fr schnelle Blinkfrequenz
SlowCounter	equ	H'68'	; Zhler fr langsame Blinkfrequenz

ICD_h70		equ	H'70'	; Reserviert fr In-Circuit-Debugging
SpiegelPA	equ	H'71'	; Abbild des Ausgabeports A
SpiegelPB	equ	H'72'	; Abbild des Ausgabeports B
SpiegelPC	equ	H'73'	; Abbild des Ausgabeports C

w_Register      equ     H'7E'	; IRQ-Zwischenspeicher fr Working Register
s_Register      equ     H'7F'	; IRQ-Zwischenspeicher fr STATUS Register

;****************************
;*   Variablen in Bank 1    *
;*       von $A0 bis $BA    *
;* $BB...$BF ICD-Reserviert *
;****************************
VariableA	equ	H'A0'
VariableB	equ	H'A1'
VariableC	equ	H'A2'

VariableX	equ	H'B8'
VariableY	equ	H'B9'
VariableZ	equ	H'BA'

ICD_hBB		equ	H'BB'	; Reserviert fr In-Circuit-Debugging
ICD_hBC		equ	H'BC'	; Reserviert fr In-Circuit-Debugging
ICD_hBD		equ	H'BD'	; Reserviert fr In-Circuit-Debugging
ICD_hBE		equ	H'BE'	; Reserviert fr In-Circuit-Debugging
ICD_hBF		equ	H'BF'	; Reserviert fr In-Circuit-Debugging

;*************************************
;* Bitweise definition von Variablen *
;*************************************
#define LEDAK		SpiegelPC,7	; Status-LED Katode bei rot Anode bei grn
#define LEDKA		SpiegelPC,6	; Status-LED Anode bei rot Katode bei grn
#define	DIAGPIN		SpiegelPC,5	; 
#define MirPC4		SpiegelPC,4	; 
#define MirPC3		SpiegelPC,3	; 
#define MirPC2		SpiegelPC,2	; 
#define	MirPC1		SpiegelPC,1	; 
#define	MirPC0		SpiegelPC,0	; 

#define	Timer1Run	TimerFlags,0	; Softwaremiger Timer luft (fr "harte" wartezeiten)
#define	Timer1TO	TimerFlags,1	; Softwaremiger Timer TimeOut (fr "harte" wartezeiten)
#define	Timer2Run	TimerFlags,2	; Softwaremiger Timer luft
#define	Timer2TO	TimerFlags,3	; Softwaremiger Timer TimeOut 
#define	Timer3Run	TimerFlags,4	; Softwaremiger Timer luft
#define	Timer3TO	TimerFlags,5	; Softwaremiger Timer TimeOut 
#define TF_not_used_6	TimerFlags,6	; 
#define PICTimer1TO	TimerFlags,7	; PIC-Timer TMR1 abgelaufen ...

#define LED_gn_on	LEDFlags,0	; Flag Status LED grn brennt
#define LED_gn_bls	LEDFlags,1	; Flag Status LED grn blinkt slow
#define LED_gn_blf	LEDFlags,2	; Flag Status LED grn blinkt fast
#define LED_rt_on	LEDFlags,3	; Flag Status LED rot brennt
#define LED_rt_bls	LEDFlags,4	; Flag Status LED rot blinkt slow
#define LED_rt_blf	LEDFlags,5	; Flag Status LED rot blinkt fast
#define	LED_rtgn_bls	LEDFlags,6	; Flag Status LED rot/grn blinkt slow
#define	LED_rtgn_blf	LEDFlags,7	; Flag Status LED rot/grn blinkt fast

#define	Error		FlagBits,0
#define	BitFlag1	FlagBits,1
#define	BitFlag2	FlagBits,2
#define	BitFlag3	FlagBits,3
#define	BitFlag4	FlagBits,4
#define	BitFlag5	FlagBits,5
#define	BitFlag6	FlagBits,6
#define	BitFlag7	FlagBits,7

;****************************
;*                          *
;*    System - Konstanten   *
;*                          *
;****************************

RESET_VECT	equ     0       ; Reset-Vektor
IRQ_VECT	equ     4       ; IRQ-Vektor
PGM_SPACE	equ     5       ; Programmbereich

#define	CARRY	STATUS,C
#define ZERO	STATUS,Z
#define	self	1

;******************************************************************************
;*                                                                            *
;*                       M A C R O S   d e f i n i e r e n                    *
;*                                                                            *
;******************************************************************************
Bank0	macro
	bcf	STATUS,RP0	; Select Page 0
	bcf	STATUS,RP1
	endm
Bank1	macro
	bsf	STATUS,RP0	; Select Page 1
	bcf	STATUS,RP1
	endm
Bank2	macro
	bcf	STATUS,RP0	; Select Page 2
	bsf	STATUS,RP1
	endm
Bank3	macro
	bsf	STATUS,RP0	; Select Page 3
	bsf	STATUS,RP1
	endm

;****************************
;*                          *
;*         Vektoren         *
;*                          *
;****************************

		ORG	RESET_VECT	; Reset-Vektor
		nop			; fr ICD
		GOTO	RESET

		ORG	IRQ_VECT	; IRQ-Vektor
		GOTO	IRQ		; zur IRQ-Routine

		ORG     PGM_SPACE	; EPROM-Anfang

;*******************************************************************************
;*                                                                             *
;*                                                                             *
;*                         R E S E T - R O U T I N E                           *
;*                                                                             *
;*                                                                             *
;*******************************************************************************
RESET:		call	RESET_CLRRAM		; "Arbeitsspeicher" lschen
		call	RESET_PIC		; PIC-Register setzen
		call	RESET_INITVAR		; Variablen vorbelegen

		bsf	INTCON,GIE		; Interrupts freigeben
		goto	MAINLOOP

;******************************************************************************
;*                                                                            *
;*                    R e s e t p r o g r a m m t e i l e                     *
;*                                                                            *
;******************************************************************************

;*******************************
;* Hardware des PIC einstellen *
;*******************************
RESET_PIC	
		bsf	STATUS,RP0	; Umschaltung auf BANK 3 + + + + + + + + + + + + + + +
		bsf	STATUS,RP1

		movlw	B'00000000'	; EEPROM Konfigurationsregister 1
;			  ||||||||
;			  |||||||+-- RD: Read EEProm (cleared by Hardware)
;			  ||||||+--- WR: Write EEProm (cleard by Hardware)
;			  |||||+---- WrEn: EEPROM Write Enable Bit
;			  ||||+----- WrErr: EEProm Write Error Flag
;			  |||+------ -
;			  ||+------- -
;			  |+-------- -	
;			  +--------- EEPGD: Access DataMemory =0/ ProgramMemory=1
		movwf	EECON1
		
		bcf	STATUS,RP0	; Umschaltung auf BANK 2 + + + + + + + + + + + + + + +
		bsf	STATUS,RP1
		
		bsf	STATUS,RP0	; Umschaltung auf BANK 1 + + + + + + + + + + + + + + +
		bcf	STATUS,RP1	

		movlw	B'10000110'	; Timer 0 einstellen
;			  ||||||||
;			  |||||||+-- PS0: Prescaler Bit 0 = div 128
;			  ||||||+--- PS1: Prescaler Bit 1
;			  |||||+---- PS2: Prescaler Bit 2
;			  ||||+----- PSA: Prescaler fr: 0=Timer, 1=Watchdog
;			  |||+------ T0SE: Timer Pin: Increment 0=Lo/Hi, 1=Hi/Lo
;			  ||+------- T0CD: Timer-Quelle: 0=Int.Takt, 1=Timer Pin
;			  |+-------- INTEDG: ext Interrupt-Flanke (0 = high->low)
;			  +--------- -RBPU: PortB mit Pull-Ups
		movwf	OPTION_REG

		movlw	B'00110000'	; Port A Richtungen einstellen
;			    ||||||
;			    |||||+-- RA0: 0=Output, 1=Input or Analog :OUT7
;			    ||||+--- RA1: 0=Output, 1=Input or Analog :OUT8
;			    |||+---- RA2: 0=Output, 1=Input or Analog :OUT9
;			    ||+----- RA3: 0=Output, 1=Input or Analog :OUT10
;			    |+------ RA4: 0=Output, 1=Input or Analog :IN9
;			    +------- RA5: 0=Output, 1=Input or Analog :IN10
                movwf   TRISA

		movlw	B'11111111'	; Port B Richtungen einstellen
;			  ||||||||
;			  |||||||+-- RB0: 0=Output, 1=Input
;			  ||||||+--- RB1: 0=Output, 1=Input
;			  |||||+---- RB2: 0=Output, 1=Input
;			  ||||+----- RB3: 0=Output, 1=Input
;			  |||+------ RB4: 0=Output, 1=Input
;			  ||+------- RB5: 0=Output, 1=Input
;			  |+-------- RB6: 0=Output, 1=Input
;			  +--------- RB7: 0=Output, 1=Input
                movwf   TRISB

		movlw	B'00000000'	; Port C Richtungen einstellen
;			  ||||||||
;			  |||||||+-- RC0: 0=Output, 1=Input :OUT1
;			  ||||||+--- RC1: 0=Output, 1=Input :OUT2
;			  |||||+---- RC2: 0=Output, 1=Input :OUT3
;			  ||||+----- RC3: 0=Output, 1=Input :OUT4
;			  |||+------ RC4: 0=Output, 1=Input :OUT5
;			  ||+------- RC5: 0=Output, 1=Input :OUT6
;			  |+-------- RC6: 0=Output, 1=Input :OUT LEDAK
;			  +--------- RC7: 0=Output, 1=Input :OUT LEDKA
                movwf   TRISC

		movlw	B'00000000'	; Interrupt Enable Register1
;                         ||||||||
;                         |||||||+-- TMR1IE: Timer1 Overflow Interrupt enable
;                         ||||||+--- TMR2IE: Timer2 to PR2 Match Interrupt enable
;                         |||||+---- CCP1IE: CCP1 Interrupt enable
;                         ||||+----- SSPIE: Sync. Serial Port Interrupt enable
;                         |||+------ -
;                         ||+------- -
;                         |+-------- ADIE: AD-Converter Interrupt Enable bit
;                         +--------- -
		movwf	PIE1

		movlw	B'00000000'	; Interrupt Enable Register1
;                         ||||||||
;                         |||||||+-- -
;                         ||||||+--- -
;                         |||||+---- -
;                         ||||+----- BCLIE: Bus Collision Interrupt Enable
;                         |||+------ EEIE: EEPROM Write Operation Interrupt
;                         ||+------- -
;                         |+-------- -
;                         +--------- -
		movwf	PIE2

		movlw	B'00000011'	; Power-On-Reset konfigurieren
;                         ||||||||
;                         |||||||+-- BOR: Brown-Out Reset occurs
;                         ||||||+--- POR: Power-On Reset occurs
;                         |||||+---- not used
;                         ||||+----- not used
;                         |||+------ not used
;                         ||+------- not used
;                         |+-------- not used
;                         +--------- not used
		movwf	PCON

		movlw	B'00000000'	; Snyc. Serial Port Control (I2C Master only)
;                         ||||||||
;                         |||||||+-- SEN: Start Condition Enable Bit
;                         ||||||+--- RSEN: Repeated Start Condition Enable Bit
;                         |||||+---- PEN: Stop Condition Enable Bit
;                         ||||+----- RCEN: Receive Enable Bit
;                         |||+------ ACKEN: Acknowledge Sequens Enable Bit
;                         ||+------- ACKDT: Acknowledge Data Bit
;                         |+-------- ACKSTAT: Acknowledge Status Bit
;                         +--------- GCEN: General Call Enable Bit
		movwf	SSPCON2
		
		movlw	Timer2Per	; Timer 2 Periode
		movwf	PR2

		movf	SSPAdr,w	; Snyc. Serial Port Adressregister (I2C Master only)
		movwf	SSPADD

		movlw	B'00000000'	; Sync. Serial Port Statusregister
;                         ||||||||
;                         |||||||+-- BF: Buffer Full
;                         ||||||+--- UA: Update Adress
;                         |||||+---- R/W: Read/Write Bit information
;                         ||||+----- S: Startbit
;                         |||+------ P: Stopbit
;                         ||+------- D/A: Data / -Adressbit
;                         |+-------- CKE: SPI Clock Edge Select
;                         +--------- SMP: Samplebit
		movwf	SSPSTAT

		movlw	B'00000010'	; 
;                         ||||||||
;                         |||||||+-- PCFG0: AD-Port Configuration Bit 0
;                         ||||||+--- PCFG1: AD-Port Configuration Bit 1
;                         |||||+---- PCFG2: AD-Port Configuration Bit 2
;                         ||||+----- PCFG3: AD-Port Configuration Bit 3
;                         |||+------ -
;                         ||+------- -
;                         |+-------- -
;                         +--------- ADFM: AD-Result Format 
		movwf	ADCON1

		bcf	STATUS,RP0	; Umschaltung auf BANK 0 + + + + + + + + + + + + + + +
		bcf	STATUS,RP1

		movlw	Timer0Val	; Timerwert holen
		movwf	TMR0		; und Timer 0 setzen	

                movlw   B'00001111'	; Hardware an Port A voreinstellen
;                           ||||||
;                           |||||+-- 
;                           ||||+--- 
;                           |||+---- 
;                           ||+----- 
;                           |+------ 
;                           +------- 
		movwf	SpiegelPA
                movwf   PORTA

                movlw   B'11111111'	; Hardware an Port B voreinstellen
;                         ||||||||
;                         |||||||+-- 
;                         ||||||+--- 
;                         |||||+---- 
;                         ||||+----- 
;                         |||+------ 
;                         ||+------- 
;                         |+-------- 
;                         +--------- 
		movwf	SpiegelPB
                movwf   PORTB

                movlw   B'00111111'	; Hardware an Port C voreinstellen
;                         ||||||||
;                         |||||||+-- 
;                         ||||||+--- 
;                         |||||+---- 
;                         ||||+----- 
;                         |||+------ 
;                         ||+------- 
;                         |+-------- 
;                         +--------- 
		movwf	SpiegelPC
                movwf   PORTC

                movlw   B'10100000'
;                         ||||||||
;                         |||||||+-- RBIF: GPIO interrupt Flag ! erst am Ende von RESET freigeben
;                         ||||||+--- INTF: external interrupt Flag (RB0-INT)
;                         |||||+---- T0IF: Timer 0 interrupt Flag
;                         ||||+----- RBIE: GPIO change interrupt disable
;                         |||+------ INTE: external interrupt disable
;                         ||+------- T0IE: Timer 0 interrupt disable
;                         |+-------- PEIE: Peripheral Interrupt disable
;                         +--------- GIE:  Enable all interrupts
		movwf   INTCON

		movlw	B'00000000'	; Peripheral Interrupt Flags 1
;                         ||||||||
;                         |||||||+-- TMR1IF: Timer 1 Interrupt Flag bit
;                         ||||||+--- TMR2IF: Timer 2 Interrupt Flag bit
;                         |||||+---- CCP1IF: CCP1 Interrupt 
;                         ||||+----- SSPIF: Syn. Serial  Port Interrupt Flag
;                         |||+------ -
;                         ||+------- -
;                         |+-------- ADIF: AD-Converter Interrupt Flag bit
;                         +--------- -
		movwf	PIR1

		movlw	B'00000000'	; Peripheral Interrupt Flags 2
;                         ||||||||
;                         |||||||+-- -
;                         ||||||+--- -
;                         |||||+---- -
;                         ||||+----- BCLIF: Bus Collision Interrupt Flag
;                         |||+------ EEIF: EEPROM Write Operation Interupt Flag
;                         ||+------- -
;                         |+-------- -
;                         +--------- -
		movwf	PIR2

		movlw	Timer1Lo	; Timer Startwert LO
		movwf	TMR1L

		movlw	Timer1Hi	; Timer Startwert HI
		movwf	TMR1H

		movlw	B'00000000'	; Timer 1 Configuration-Register
;                         ||||||||
;                         |||||||+-- TMR1ON: Enable/Disable Timer 1
;                         ||||||+--- TMR1CS: Timer 1 Clock Select
;                         |||||+---- T1SYNC: Timer 1 ext. Clock syncronisation
;                         ||||+----- T1OSCEN: Timer 1 oscillator enable
;                         |||+------ T1CKPS0: Timer 1 Clock Prescaler
;                         ||+------- T1CKPS1: Timer 1 Clock Prescaler
;                         |+-------- -
;                         +--------- -
		movwf	T1CON

		movlw	Timer2Reg	; Timer 2 Periode
		movwf	TMR2

		movlw	B'00000000'	; Timer 2 Configuration-Register
;                         ||||||||
;                         |||||||+-- T2CKPS0: Timer 2 Clock Prescaler
;                         ||||||+--- T2CKPS1: Timer 2 Clock Prescaler
;                         |||||+---- TMR2ON: Enable/Disable Timer 2
;                         ||||+----- TOUTPS0: Timer2 Output Postscaler
;                         |||+------ TOUTPS1: Timer2 Output Postscaler
;                         ||+------- TOUTPS2: Timer2 Output Postscaler
;                         |+-------- TOUTPS3: Timer2 Output Postscaler
;                         +--------- -
		movwf	T2CON

		movf	SSPBuf,w
		movwf	SSPBUF

		movlw	B'00000000'	; Sync Serial Port Control Register
;                         ||||||||
;                         |||||||+-- SSPM0: Sync. Serial Port Mode
;                         ||||||+--- SSPM1: Sync. Serial Port Mode
;                         |||||+---- SSPM2: Sync. Serial Port Mode
;                         ||||+----- SSPM3: Sync. Serial Port Mode
;                         |||+------ CKP: Clock Polarity Select 
;                         ||+------- SSPEN: Sync. Serial Port Enable
;                         |+-------- SSPOV: Receiv Overflow Bit
;                         +--------- WCOL: Write Collison Detect bit
		movwf	SSPCON

		movlw	CCRegLo
		movwf	CCPR1L

		movlw	CCRegHi
		movwf	CCPR1H

		movlw	B'00000000'	; Compare/Capture-Register Config
;                         ||||||||
;                         |||||||+-- CCP1M0: CCPx Mode Select 
;                         ||||||+--- CCP1M1: CCPx Mode Select
;                         |||||+---- CCP1M2: CCPx Mode Select
;                         ||||+----- CCP1M3: CCPx Mode Select
;                         |||+------ CCP1Y: PWM Least Significant bits
;                         ||+------- CCP1X: PWM Least Significant bits
;                         |+-------- -
;                         +--------- -
		movwf	CCP1CON

                movlw   B'01000000'
;                         ||||||||
;                         |||||||+-- ADON: ADC eingeschaltet
;                         ||||||+--- -
;                         |||||+---- GO/DONE: ADC Start
;                         ||||+----- CHS0: ADC-Channel-Select
;                         |||+------ CHS1: ADC-Channel-Select
;                         ||+------- CHS2: ADC-Channel-Select
;                         |+-------- ADC-Clock 00=Fosc/2  01=Fosc/8
;                         +--------- ADC-Clock 10=Fosc/32 11=intOsc
		movwf   ADCON0

xRESET_PIC	return

;***********************
;* RAM des PIC lschen *
;***********************
RESET_CLRRAM	movlw	RAM1_START		; Adresse der ersten RAM-Stelle
		movwf	FSR		    	; ins File Selection Register schreiben
RAMclrL1:	clrf	INDF			; RAM lschen
	 	incf	FSR,F			; nchste RAM-Stelle
		movlw	RAM1_END+1		; FSR >= Ende erreicht?
		subwf	FSR,w
		btfss	STATUS,C
		goto	RAMclrL1

CLRRAM2		movlw	RAM2_START		; Adresse der ersten RAM-Stelle
		movwf	FSR		    	; ins File Selection Register schreiben
RAMclrL2:	clrf	INDF			; RAM lschen
	 	incf	FSR,F			; nchste RAM-Stelle
		movlw	RAM2_END+1		; FSR >= Ende erreicht?
		subwf	FSR,w
		btfss	STATUS,C
		goto	RAMclrL2

		return

;****************************
;* Variablen initialisieren *
;****************************
RESET_INITVAR	movlw	kBlkSlow	; alle Blinkzhler fr IRQ vorbelegen
		movwf	SlowCounter
		movlw	kBlkFast
		movwf	FastCounter
		movlw	ScaleFaktor2		; Vorteilerwert holen
		movwf	PreScaler2		; und Vorteiler setzen
		movlw	ScaleFaktor3		; Vorteilerwert holen
		movwf	PreScaler3		; und Vorteiler setzen

xRESET_INITVAR	return


;******************************************************************************
;*                                                                            *
;*                                                                            *
;*                  H A U P T P R O G R A M M S C H L E I F E                 *
;*                                                                            *
;*                                                                            *
;******************************************************************************
MAINLOOP	clrwdt			; Watchdog ruhigstellen

		call	MAIN1		; Aufruf der Hauptprogrammteile 
;		call	MAIN2		; BEISPIEL ...
		call	MAIN3

xMAINLOOP	goto	MAINLOOP

;******************************************************************************
;*                                                                            *
;*                    H a u p t p r o g r a m m t e i l e                     *
;*                                                                            *
;******************************************************************************

;****************************
;* Hauptprogrammteil MAIN1  *
;****************************
MAIN1		nop

		bcf	SpiegelPC,0
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,0

		bcf	SpiegelPC,1
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,1

		bcf	SpiegelPC,2
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,2

		bcf	SpiegelPC,3
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,3

		bcf	SpiegelPC,4
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,4

		bcf	SpiegelPC,5
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPC,5

		bcf	SpiegelPA,0
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPA,0

		bcf	SpiegelPA,1
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPA,1

		bcf	SpiegelPA,2
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPA,2

		bcf	SpiegelPA,3
		call	BIOS_Out_AC
		call	FastBlink
		bsf	SpiegelPA,3

xMAIN1		return

;****************************
;* Hauptprogrammteil MAIN2  *
;****************************
MAIN2		nop
		call	Kanal1

xMAIN2		return

Kanal1		bcf	SpiegelPC,0		; Bitmuster vorbereiten
		call	BIOS_Out_AC		; und ausgeben
		call	FastBlink		; Ablaufverzgerung mit Blinken

		movf	PORTB,w			; Bitmuster vom Port holen
		andlw	B'11111111'		; relevante Bits ausmaskieren
		movwf	InBitsB			; und merken

		movf	PORTA,w			; Bitmuster vom Port holen
		andlw	B'00110000'		; relevante Bits ausmaskieren
		movwf	InBitsA			; und merken

		bsf	SpiegelPC,0		; Bitmuster rcksetzen
		call	BIOS_Out_AC		; und ausgeben

K1B		movf	InBitsB,w		; Wert vom Port holen
		andlw	B'11111111'		; relevante Bits ausmaskieren
		sublw	B'11111110'		; mit Erwartung vergleichen
		btfss	ZERO			; ist Wert gleich? ja =>
		goto	K1NIO

K1C		movf	InBitsA,w		; Wert vom Port holen
		andlw	B'00110000'		; relevante Bits ausmaskieren
		sublw	B'00110000'		; mit Erwartung vergleichen
		btfss	ZERO			; ist Wert gleich? ja =>
		goto	K1NIO		

K1IO		call	KanalIO
		goto	xKanal1
K1NIO		call	KanalNIO
xKanal1		return


; *** Prfschritt ok anzeigen ***
KanalIO		bsf	LED_gn_on
		call	Wait250msec
		bcf	LED_gn_on
		return

; *** Prfschritt ok anzeigen ***
KanalNIO	bsf	Error
		bsf	LED_rt_on
		call	Wait250msec
		bcf	LED_rt_on
		return

;****************************
;* Hauptprogrammteil MAIN2  *
;****************************
MAIN3		btfss	Error
		goto	TestOK

TestNOK		call	TestNIO		
		goto	MAIN3Loop

TestOK		call	TestIO		
		goto	MAIN3Loop

MAIN3Loop	clrwdt
		goto	MAIN3Loop

xMAIN3		return

; *** Prfung ok anzeigen ***
TestIO		bsf	LED_gn_bls
		return

; *** Prfung nicht ok anzeigen ***
TestNIO	bsf	LED_rt_blf
		return

;*****************************
;* Unterprogramme von MAIN1  *
;*****************************
FastBlink	call	Start500msec	
		bcf	Timer2TO
FastBlinkLoop	clrwdt

		bcf	SpiegelPC,6
		bsf	SpiegelPC,7
		call	BIOS_Out_AC
		nop
		nop
		nop
		nop
		nop

		bsf	SpiegelPC,6
		bcf	SpiegelPC,7
		call	BIOS_Out_AC
		nop
		nop
		nop
		nop
		nop

		btfss	Timer2TO
		goto	FastBlinkLoop

xFastBlinkLoop	bcf	SpiegelPC,6
		bcf	SpiegelPC,7
		call	BIOS_Out_AC
		return



;******************************************************************************
;*                                                                            *
;*                                                                            *
;*                           I R Q  -  R o u t i n e                          *
;*                                                                            *
;*                                                                            *
;******************************************************************************
IRQ:		movwf	w_Register	; W und STATUS sichern
		swapf	STATUS,W
                bcf     STATUS,RP0	; Umschaltung auf BANK 0 weil HPG in HiBank sein kann
		movwf	s_Register

		btfsc	INTCON,T0IF	; Timerinterruptflag gesetzt? nein: =>
		goto	TimerIRQ	; Timer-IRQ-Bit gesetzt
rTimerIRQ	

		btfsc	INTCON,INTF	; ext.Interrupt-Flag gesetzt? nein; =>
		goto	RB0IRQ		; ext.Interrupt-Flag gesetzt
rRB0IRQ		

		btfsc	INTCON,RBIF	; Port-Change Interrrupt-Flag gesetzt? nein; =>
		goto	PortIRQ		; Port-Change Interrupt-Flag gesetzt
rPortIRQ	

xIRQ		swapf	s_Register,W	; W und STATUS wiederherstellen
		movwf	STATUS
		swapf	w_Register,F
		swapf	w_Register,W
		retfie

;******************************************************************************
;*                                                                            *
;*                       I R Q - P r o g r a m m t e i l e                    *
;*                                                                            *
;******************************************************************************

;****************************
;*   Timerinterruptroutine  *
;****************************
TimerIRQ	bcf	INTCON,T0IF
		movlw	Timer0Val	; Timerwert holen
		movwf	TMR0		; und Timer 0 neu setzen	

		call	Timer1		; Softwaretimer behandeln
		call	Timer2		; Softwaretimer behandeln
		call	Timer3		; Softwaretimer behandeln
		call	StatusLED	; StatusLED-Ansteueren

xTimerIRQ	goto	rTimerIRQ

;****************************
;*  Externinterruptroutine  *
;****************************
RB0IRQ		bcf	INTCON,INTF
xRB0IRQ		goto	rRB0IRQ

;****************************
;*  Port-B-Interruptroutine  *
;****************************
PortIRQ		bcf	INTCON,RBIF
xPortIRQ	goto	rPortIRQ

;**************************************
;*                                    *
;*        Unterprogramme des          *
;*           IRQ-Routinen             *
;*                                    *
;**************************************
;**************************************
;*                                    *
;*        Unterprogramme des          *
;*           IRQ-Routinen             *
;*                                    *
;**************************************

;****************************************
;* Unterprogramme der Timer-IRQ-Routine *
;****************************************

; *** Softwaretimer 1: "n" mal IRQ-Periodenzeit warten ***
Timer1		btfsc	Timer1Run		; ist Timer gestartet, luft er ?

		decfsz	Timer1Val,self		; Timer runterzhlen und schon 0? ja: =>
		goto	xTimer1			; nein: => dann raus
Abgelaufen1	bsf	Timer1TO		; TimeOut-Flag setzen
		bcf	Timer1Run		; und Timer "luft" lschen

xTimer1		return

; *** Softwaretimer 2: "n" mal IRQ-Periodenzeit mal Vorteiler warten ***
Timer2		decfsz	PreScaler2,self		; Vorteiler immer runter zhlen und null? ja:=>
		goto	xTimer2			; nein: wieder raus
		movlw	ScaleFaktor2		; Vorteilerwert holen
		movwf	PreScaler2		; und Vorteiler setzen

		btfsc	Timer2Run		; ist Timer gestartet, luft er ?
		decfsz	Timer2Val,self		; Timer runterzhlen und schon 0? ja: =>
		goto	xTimer2			; nein: => dann raus
Abgelaufen2	bsf	Timer2TO		; TimeOut-Flag setzen
		bcf	Timer2Run		; und Timer "luft" lschen

xTimer2		return

; *** Softwaretimer 3: "n" mal IRQ-Periodenzeit mal Vorteiler warten ***
Timer3		decfsz	PreScaler3,self		; Vorteiler immer runter zhlen und null? ja:=>
		goto	xTimer3			; nein: wieder raus
		movlw	ScaleFaktor3		; Vorteilerwert holen
		movwf	PreScaler3		; und Vorteiler setzen

		btfsc	Timer3Run		; ist Timer gestartet, luft er ?
		decfsz	Timer3Val,self		; Timer runterzhlen und schon 0? ja: =>
		goto	xTimer3			; nein: => dann raus
Abgelaufen3	bsf	Timer3TO			; TimeOut-Flag setzen
		bcf	Timer3Run		; und Timer "luft" lschen

xTimer3		return

; *** Zweifarben-Status-LED an 2 Portpins behandeln ***
StatusLED	movf	LEDFlags,w
		andlw	B'11000000'	; muss LED "rot-grn" behandelt werden
		btfss	ZERO		; "ein" rot/grn Bit gesetzt? nein =>
		goto	LEDrtgn		; ja: dann rt/gn behandeln
		
		movf	LEDFlags,w
		andlw	B'00111000'	; muss LED "rot" behandelt werden
		btfss	ZERO		; "ein" rot Bit gesetzt? nein =>
		goto	LEDrt		; ja: dann rt behandeln

		movf	LEDFlags,w
		andlw	B'00000111'	; muss LED "grn" behandelt werden
		btfss	ZERO		; "ein" grn Bit gesetzt? nein =>
		goto	LEDgn		; ja: dann gn behandeln

xStatusLED	bcf	LEDAK		; kein LED-Bit gesetzt:	LED ausschalten
		bcf	LEDKA		; kein LED-Bit gesetzt:	LED ausschalten
		call	BIOS_Out_C	; und Bitmuster ausgeben
		return 

; *** LED in grn behandeln ***
LEDgn		btfss	LED_gn_blf	; soll LED schnell blinken? ja: =>
		goto	Tst_gn_bls	; nein: =>
do_gn_blf	decfsz	FastCounter,f	; LED schnell blinken: Zhler abgelaufen? ja: =>
		goto	xLEDgn		; nein: dann raus		
		movlw	kBlkFast	; Zhler neu setzen
		movwf	FastCounter	
		btfsc	LEDKA		; ist LED gerade ein oder aus?
		goto	do_gn_off	; LED ein: dann ausschalten
		goto	do_gn_on	; LED aus: dann einschalten
	
Tst_gn_bls	btfss	LED_gn_bls	; soll LED langsam blinken? ja: =>
		goto	Tst_gn_on	; nein: =>	
do_gn_bls	decfsz	SlowCounter,f	; LED langsam blinken: Zhler abgelaufen? ja: =>
		goto	xLEDgn		; nein: dann raus		
		movlw	kBlkSlow	; Zhler neu setzen
		movwf	SlowCounter	
		btfsc	LEDKA		; ist LED gerade ein oder aus?
		goto	do_gn_off	; LED ein: dann ausschalten		
		goto	do_gn_on	; LED aus: dann einschalten

Tst_gn_on	btfss	LED_gn_on	; soll LED dauern brennen? ja: =>
		goto	xLEDgn		; nein: dann raus		
do_gn_on	bcf	LEDAK		; LED grn einschalten
		bsf	LEDKA	
		call	BIOS_Out_C	; und Bitmuster ausgeben
		goto	xLEDgn		; nein: =>
do_gn_off	bcf	LEDAK		; LED grn einschalten
		bcf	LEDKA	
		call	BIOS_Out_C	; und Bitmuster ausgeben
	
xLEDgn		return

; *** LED in rot behandeln ***
LEDrt		btfss	LED_rt_blf	; soll LED schnell blinken? ja: =>
		goto	Tst_rt_bls	; nein: =>
do_rt_blf	decfsz	FastCounter,f	; LED schnell blinken: Zhler abgelaufen? ja: =>
		goto	xLEDrt		; nein: dann raus		
		movlw	kBlkFast	; Zhler neu setzen
		movwf	FastCounter	
		btfsc	LEDAK		; ist LED gerade ein oder aus?
		goto	do_rt_off	; LED ein: dann ausschalten
		goto	do_rt_on	; LED aus: dann einschalten
	
Tst_rt_bls	btfss	LED_rt_bls	; soll LED langsam blinken? ja: =>
		goto	Tst_rt_on	; nein: =>	
do_rt_bls	decfsz	SlowCounter,f	; LED langsam blinken: Zhler abgelaufen? ja: =>
		goto	xLEDrt		; nein: dann raus		
		movlw	kBlkSlow	; Zhler neu setzen
		movwf	SlowCounter	
		btfsc	LEDAK		; ist LED gerade ein oder aus?
		goto	do_rt_off	; LED ein: dann ausschalten		
		goto	do_rt_on	; LED aus: dann einschalten

Tst_rt_on	btfss	LED_rt_on	; soll LED dauern brennen? ja: =>
		goto	xLEDrt		; nein: dann raus		
do_rt_on	bsf	LEDAK		; LED grn einschalten
		bcf	LEDKA	
		call	BIOS_Out_C	; und Bitmuster ausgeben
		goto	xLEDrt		; nein: =>
do_rt_off	bcf	LEDKA		; LED grn einschalten
		bcf	LEDAK	
		call	BIOS_Out_C	; und Bitmuster ausgeben
	
xLEDrt		return

; *** LED in rot-grn behandeln ***
LEDrtgn		btfss	LED_rtgn_blf	; soll LED schnell blinken? ja: =>
		goto	Tst_rtgn_bls	; nein: =>
do_rtgn_blf	decfsz	FastCounter,f	; LED schnell blinken: Zhler abgelaufen? ja: =>
		goto	xLEDrtgn	; nein: dann raus		
		movlw	kBlkFast	; Zhler neu setzen
		movwf	FastCounter	
		btfsc	LEDAK		; ist LED gerade rot oder grn?
		goto	do_gn_rt	; LED grn: dann rot schalten		
		goto	do_rt_gn	; LED rot: dann grn schalten
	
Tst_rtgn_bls	btfss	LED_rtgn_bls	; soll LED langsam blinken? ja: =>
		goto	xLEDrtgn	; nein: =>	
do_rtgn_bls	decfsz	SlowCounter,f	; LED langsam blinken: Zhler abgelaufen? ja: =>
		goto	xLEDrtgn	; nein: dann raus		
		movlw	kBlkSlow	; Zhler neu setzen
		movwf	SlowCounter	
		btfsc	LEDAK		; ist LED gerade ein oder aus?
		goto	do_gn_rt	; LED grn: dann rot schalten		
		goto	do_rt_gn	; LED rot: dann grn schalten

do_rt_gn	bsf	LEDAK		; LED grn schalten
		bcf	LEDKA	
		call	BIOS_Out_C	; und Bitmuster ausgeben
		goto	xLEDrt		; nein: =>
do_gn_rt	bsf	LEDKA		; LED rot schalten
		bcf	LEDAK	
		call	BIOS_Out_C	; und Bitmuster ausgeben
	
xLEDrtgn	return

;***********************************************
;* Rechtecksignal an RC4 (nur fr Debugzwecke) *
;***********************************************
Rechteck	btfss	DIAGPIN
		goto	SetBitRC
ClrBitRC	bcf	DIAGPIN		; Bit ist Hi: also lschen
		call	BIOS_Out_C
		goto	xRechteck
SetBitRC	bsf	DIAGPIN		; Bit ist Lo: also setzen
		call	BIOS_Out_C
xRechteck	return

;******************************************************************************
;*                                                                            *
;*                a l l g e m e i n e  U n t e r p r o g r a m m e            *
;*                                                                            *
;******************************************************************************
;* alle Digital-Ports ausgeben*
BIOS_Out_C	movf	SpiegelPC,w
		movwf	PORTC
xBIOS_Out_C	return

BIOS_Out_AC	movf	SpiegelPA,w
		movwf	PORTA
		movf	SpiegelPC,w
		movwf	PORTC
xBIOS_Out_AC	return

;***************************************************
;* diverse Standardwartezeiten WARTEN (nichts tun) *
;*   diese Routinen benutzen den Softwaretimer1    *
;*    {Auflsung von 10msec (10msec...2.55sec)}    *
;***************************************************

Wait100msec	movlw	k100msec
		call	WaitMyTimer
		return

Wait250msec	movlw	k250msec
		call	WaitMyTimer
		return

Wait500msec	movlw	k500msec
		call	WaitMyTimer
		return

Wait1sec	movlw	k1sec
		call	WaitMyTimer
		return
Wait2sec	movlw	k2sec
		call	WaitMyTimer
		return

Wait2k5sec	movlw	k2k5sec
		call	WaitMyTimer
		return

;**************************************
;* in "W" angegebene Wartezeit warten *
;**************************************
WaitMyTimer	movwf	Timer1Val	; Timer setzen und ...
		bsf	Timer1Run	; ... Timer starten

WaitLoop	clrwdt
		btfss	Timer1TO	; TimeOut vom Timer gesetzt? nein: =>
		goto	WaitLoop

ExitWaitLoop	bcf	Timer1TO	
xWaitMyTimer	return	

;********************************************************
;* diverse Routinen starten einen Timer der nach Ablauf *
;* ein Flag setzt das im Programm gepllt werden muss    *
;*      diese Routinen benutzen den Softwaretimer2      *
;*     {Auflsung von 100msec (100msec...25.5sec)}      *
;********************************************************
Start500msec	movlw	kPS500msec
		movwf	Timer2Val	; Timer setzen und ...
		bsf	Timer2Run	; ... Timer starten
		return

Start1sec	movlw	kPS1sec
		movwf	Timer2Val	; Timer setzen und ...
		bsf	Timer2Run	; ... Timer starten
		return

Start2sec	movlw	kPS2sec
		movwf	Timer2Val	; Timer setzen und ...
		bsf	Timer2Run	; ... Timer starten
		return

Start2k5sec	movlw	kPS2k5sec
		movwf	Timer2Val	; Timer setzen und ...
		bsf	Timer2Run	; ... Timer starten
		return

Start5sec	movlw	kPS5sec
		movwf	Timer2Val	; Timer setzen und ...
		bsf	Timer2Run	; ... Timer starten
		return

;******************************************************************************
;*                                                                            *
;*                         externe Quellfiles miteinbinden                    *
;*                                                                            *
;******************************************************************************
;               include file.inc

;******************************************************************************
;*                              ENDE des QUELLTEXTES                          *
;******************************************************************************
	end
